# Rethinking Knowledge Distillation via Cross-Entropy
# Installation
* Install pytorch

* [Install mmcv (  mmcv-full == 1.3.17 )](https://github.com/open-mmlab/mmcv#installation)

* Install

  ```
  pip install -r requirements/*
  ```

# Train

```
#single GPU
python tools/train.py configs/distillers/imagenet/res34_distill_res18_img.py

#multi GPU
bash tools/dist_train.sh configs/distillers/imagenet/res34_distill_res18_img.py 8
```

# Transfer
```
# Tansfer the distillation model into mmdet model
python pth_transfer.py --nkd_path $nkd_ckpt --output_path $new_mmdet_ckpt
```
# Test

```
#single GPU
python tools/test.py configs/resnet/resnet18_8xb32_in1k.py $new_mmdet_ckpt --metrics accuracy

#multi GPU
bash tools/dist_test.sh configs/resnet/resnet18_8xb32_in1k.py $new_mmdet_ckpt 8
```

# Acknowledgement

Our code is based on the project [MMClassification](https://github.com/open-mmlab/mmclassification).